#include <bits/stdc++.h>
using namespace std;

const long long INF = 4e18;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n), h(n);
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    vector<long long> ans(n, INF);
    stack<int> st;

    auto check = [&](int i, int j) {
        // jarbol j u odnosu na i
        ans[i] = min(ans[i],
            llabs(x[i] - x[j]) + llabs(h[j] - h[i]));

        // kanap izmedu i i j
        long long dx = llabs(x[j] - x[i]);
        long long xmin_num = x[i] + x[j] + h[i] - h[j];
        if (xmin_num % 2 != 0) return;

        long long xmin = xmin_num / 2;
        long long hmax = h[i] - llabs(xmin - x[i]);

        if (hmax < h[i]) return;

        long long dist = llabs(hmax - h[i]);
        ans[i] = min(ans[i], dist);
    };

    // LEVO ? DESNO
    for (int i = 0; i < n; i++) {
        while (!st.empty() && h[st.top()] < h[i])
            st.pop();
        if (!st.empty())
            check(i, st.top());
        st.push(i);
    }

    while (!st.empty()) st.pop();

    // DESNO ? LEVO
    for (int i = n - 1; i >= 0; i--) {
        while (!st.empty() && h[st.top()] < h[i])
            st.pop();
        if (!st.empty())
            check(i, st.top());
        st.push(i);
    }

    for (int i = 0; i < n; i++) {
        if (ans[i] == INF) cout << -1 << "\n";
        else cout << ans[i] << "\n";
    }
}